% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dann.R
\name{dann_df}
\alias{dann_df}
\title{Discriminant Adaptive Nearest Neighbor Classification}
\usage{
dann_df(
  formula,
  train,
  test,
  k = 5,
  neighborhood_size = max(floor(nrow(train)/5), 50),
  epsilon = 1,
  probability = FALSE
)
}
\arguments{
\item{formula}{An object of class formula. (Y ~ X1 + X2)}

\item{train}{A data frame or tibble containing training data.}

\item{test}{A data frame or tibble containing test data.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}

\item{probability}{Should probabilities instead of classes be returned?}
}
\value{
A numeric vector containing predicted class or a numeric matrix containing class probabilities.
}
\description{
Discriminant Adaptive Nearest Neighbor Classification
}
\details{
This is an implementation of Hastie and Tibshirani's
\href{https://web.stanford.edu/~hastie/Papers/dann_IEEE.pdf}{Discriminant Adaptive Nearest
Neighbor Classification publication.}.
The code is a port of Christopher Jenness's
python \href{https://github.com/christopherjenness/ML-lib}{implementation.}
}
\examples{
library(dann)
library(mlbench)
library(magrittr)
library(dplyr)
library(ggplot2)

######################
# Circle Data
######################
set.seed(1)
train <- mlbench.circle(300, 2) \%>\%
  tibble::as_tibble()
colnames(train) <- c("X1", "X2", "Y")
train <- train \%>\%
  mutate(Y = as.numeric(Y))

ggplot(train, aes(x = X1, y = X2, colour = as.factor(Y))) +
  geom_point() +
  labs(title = "Train Data", color = "Y")

test <- mlbench.circle(100, 2) \%>\%
  tibble::as_tibble()
colnames(test) <- c("X1", "X2", "Y")
test <- test \%>\%
  mutate(Y = as.numeric(Y))

ggplot(test, aes(x = X1, y = X2, colour = as.factor(Y))) +
  geom_point() +
  labs(title = "Test Data", color = "Y")

dannPreds <- dann_df(
  formula = Y ~ X1 + X2,
  train = train, test = test,
  k = 3, neighborhood_size = 50, epsilon = 1,
  probability = FALSE
)
mean(dannPreds == test$Y) # An accurate model.

rm(train, test)
rm(dannPreds)
}
