% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_similar_labels.R
\name{detect_similar_labels}
\alias{detect_similar_labels}
\title{Search for similar labels in a column}
\usage{
detect_similar_labels(activitylog, column_labels, max_edit_distance = 3,
  show_NA = FALSE, ignore_capitals = FALSE, filter_condition = NULL)
}
\arguments{
\item{activitylog}{The activity log}

\item{column_labels}{The name of the column(s) in which to search for spelling mistakes}

\item{max_edit_distance}{The maximum number of insertions, deletions and substitutions that are allowed to be executed in order for two strings to be considered similar.}

\item{show_NA}{A boolean indicating if labels that do not show similarities with others should be shown in the output}

\item{ignore_capitals}{A boolean indicating if capitalization should be included or excluded when calculating the edit distance between two strings}

\item{filter_condition}{Condition that is used to extract a subset of the activity log prior to the application of the function}
}
\value{
tbl_df providing an overview of similar labels for the indicated column
}
\description{
Function that tries to detect spelling mistakes in a given activity log column
}
\examples{
\donttest{
data("hospital_actlog")
detect_similar_labels(activitylog = hospital_actlog,
     column_labels = "activity",
     max_edit_distance = 3)
}
}
