% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.write.csv.r
\name{gl.write.csv}
\alias{gl.write.csv}
\title{Writes out data from a genlight object to csv file}
\usage{
gl.write.csv(x, outfile = "outfile.csv", outpath = tempdir(), verbose = NULL)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{File name of the output file (including extension)
[default "outfile.csv"].}

\item{outpath}{Path where to save the output file
[default tempdir(), mandated by CRAN]. Use outpath=getwd() or outpath='.'
when calling this function to direct output files to your working directory.}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end;
2, progress log; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
Saves a genlight object to csv, returns NULL.
}
\description{
This script writes to file the SNP genotypes with specimens as entities
(columns) and loci as attributes (rows). Each row has associated locus
 metadata. Each column, with header of specimen id, has population in the
 first row.
The data coding differs from the DArT 1row format in that 0 = reference
homozygous, 2 = alternate homozygous, 1 = heterozygous, and NA = missing SNP
assignment.
}
\examples{
# SNP data
  gl.write.csv(testset.gl, outfile='SNP_1row.csv')
# Tag P/A data
  gl.write.csv(testset.gs, outfile='PA_1row.csv')
}
\seealso{
Other io: 
\code{\link{gl.load}()},
\code{\link{gl.read.csv}()},
\code{\link{gl.read.dart}()},
\code{\link{gl.read.fasta}()},
\code{\link{gl.read.silicodart}()},
\code{\link{gl.read.vcf}()},
\code{\link{gl.save}()},
\code{\link{utils.read.dart}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{io}
