% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl2eigenstrat.r
\name{gl2eigenstrat}
\alias{gl2eigenstrat}
\title{Converts a genlight object into eigenstrat format}
\usage{
gl2eigenstrat(
  x,
  outfile = "gl_eigenstrat",
  outpath = NULL,
  snp.pos = 1,
  snp.chr = 1,
  pos.cM = 0,
  sex.code = "unknown",
  phen.value = "Case",
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{File name of the output file [default 'gl_eigenstrat'].}

\item{outpath}{Path where to save the output file [default global working 
directory or if not specified, tempdir()].}

\item{snp.pos}{Field name from the slot loc.metrics where the SNP position is
stored [default 1].}

\item{snp.chr}{Field name from the slot loc.metrics where the chromosome of
each is stored [default 1].}

\item{pos.cM}{A vector, with as many elements as there are loci, containing
the SNP position in morgans or centimorgans [default 1].}

\item{sex.code}{A vector, with as many elements as there are individuals,
containing the sex code ('male', 'female', 'unknown') [default 'unknown'].}

\item{phen.value}{A vector, with as many elements as there are individuals,
containing the phenotype value ('Case', 'Control') [default 'Case'].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2 or as specified using gl.set.verbosity].}
}
\value{
returns no value (i.e. NULL)
}
\description{
The output of this function are three files:
\itemize{
\item genotype file: contains genotype data for each individual at each SNP
with an extension 'eigenstratgeno.'
\item snp file: contains information about each SNP with an extension 'snp.'
\item indiv file: contains information about each individual with an
extension 'ind.'
}
}
\details{
Eigenstrat only accepts chromosomes coded as numeric values, as follows:
X chromosome is encoded as 23, Y is encoded as 24, mtDNA is encoded as
90, and XY is encoded as 91. SNPs with illegal chromosome values, such
as 0, will be removed.
}
\examples{
\donttest{
require("dartR.data")
gl2eigenstrat(platypus.gl,snp.pos='ChromPos_Platypus_Chrom_NCBIv1',
snp.chr = 'Chrom_Platypus_Chrom_NCBIv1', outpath=tempdir())
}

}
\references{
\itemize{
\item Patterson, N., Price, A. L., & Reich, D. (2006). Population structure
and eigenanalysis. PLoS genetics, 2(12), e190.
\item Price, A. L., Patterson, N. J., Plenge, R. M., Weinblatt, M. E.,
Shadick, N. A., & Reich, D. (2006). Principal components analysis corrects
for stratification in genome-wide association studies. Nature genetics,
38(8), 904-909.
}
}
\seealso{
Other linker: 
\code{\link{gl2bayesAss}()},
\code{\link{gl2bayescan}()},
\code{\link{gl2bpp}()},
\code{\link{gl2demerelate}()},
\code{\link{gl2faststructure}()},
\code{\link{gl2gds}()},
\code{\link{gl2genalex}()},
\code{\link{gl2genepop}()},
\code{\link{gl2geno}()},
\code{\link{gl2gi}()},
\code{\link{gl2hiphop}()},
\code{\link{gl2phylip}()},
\code{\link{gl2plink}()},
\code{\link{gl2related}()},
\code{\link{gl2sa}()},
\code{\link{gl2structure}()},
\code{\link{gl2treemix}()},
\code{\link{gl2vcf}()}
}
\author{
Custodian: Luis Mijangos 
(Post to \url{https://groups.google.com/d/forum/dartr})
}
\concept{linker}
