% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.run.EMIBD9.R
\name{gl.run.EMIBD9}
\alias{gl.run.EMIBD9}
\title{Run program EMIBD9}
\usage{
gl.run.EMIBD9(
  x,
  outfile = "EMIBD9_Res.ibd9",
  outpath = tempdir(),
  emibd9.path = getwd(),
  Inbreed = TRUE,
  ISeed = 42,
  plot.out = TRUE,
  plot.dir = NULL,
  plot.file = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{outfile}{A string, giving the path and name of the output file
[default "EMIBD9_Res.ibd9"].}

\item{outpath}{Path where to save the output file. Use outpath=getwd() or
outpath='.' when calling this function to direct output files to your working 
or current directory [default tempdir(), mandated by CRAN].}

\item{emibd9.path}{Path to the folder emidb files.
Please note there are 2 different executables depending on your OS:
EM_IBD_P.exe (=Windows) EM_IBD_P (=Mac, Linux). 
You only need to pointto the folder (the function will recognise which OS you
are running) [default getwd()].}

\item{Inbreed}{A Boolean, taking values 0 or 1 to indicate inbreeding is not
and is allowed in estimating IBD coefficients [default 1].}

\item{ISeed}{An integer used to seed the random number generator [default 42].}

\item{plot.out}{A boolean that indicates whether to plot the results [default TRUE].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
A matrix with pairwise relatedness
}
\description{
Run program EMIBD9
}
\details{
Download the program from here:

https://www.zsl.org/about-zsl/resources/software/emibd9

For Windows, Mac and Linux install the program then point to the folder where you find:
EM_IBD_P.exe (=Windows) and EM_IBD_P (=Mac, Linux). If running really slow you may 
want to create the files using the function and then run in parallel using the
documentation provided by the authors [you need to have mpiexec installed].
}
\examples{
\dontrun{
#To run this function needs EMIBD9 installed in your computer
t1 <- gl.filter.allna(platypus.gl)
res_rel <- gl.run.EMIBD9(t1)
}

}
\references{
\itemize{
\item Wang, J. (2022). A joint likelihood estimator of relatedness and allele
 frequencies from a small sample of individuals. Methods in Ecology and
 Evolution, 13(11), 2443-2462.
}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
