% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.collapse.r
\name{gl.collapse}
\alias{gl.collapse}
\title{Collapse a distance matrix by amalgamating populations}
\usage{
gl.collapse(fd, gl, recode.table = "tmp.csv", t = 0, iter = 1)
}
\arguments{
\item{fd}{-- name of the distance matrix produced by gl.fixed.diff() [required]}

\item{gl}{-- name of the genlight object from which the distance matrix was calculated [required]}

\item{recode.table}{-- name of the new recode.table to receive the population reassignments 
arising from the amalgamation of populations [default tmp.csv]}

\item{t}{-- the threshold distance value for amalgamating populations [default 0]}

\item{iter}{-- a parameter to indicate the cycle when gl.collapse() is used interatively [default 1]}
}
\value{
The new genlight object with recoded populations
}
\description{
This script takes a distance matrix (d in lower matrix) and generates a population recode
table to amalgamate populations with distance less than or equal to a specified threshold
The distance matrix is generated by gl.fixed.diff()
}
\examples{
#only used the first 20 individuals due to runtime reasons 
fd <- gl.fixed.diff(testset.gl[1:20,], t=0.05)
gl <- gl.collapse(fd, testset.gl[1:20,], recode.table="testset_recode.csv",t=0.026)
}
\author{
Arthur Georges and Aaron Adamnack (glbugs@aerg.canberra.edu.au)
}

