% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.smearplot.r
\name{gl.smearplot}
\alias{gl.smearplot}
\title{Smear plot of SNP or presence/absence (SilicoDArT) data}
\usage{
gl.smearplot(
  x,
  ind_labels = FALSE,
  group_pop = FALSE,
  ind_labels_size = 10,
  plot_colors = NULL,
  posi = "bottom",
  save2tmp = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{ind_labels}{If TRUE, individuals are labelled with indNames(x) [default FALSE].}

\item{group_pop}{If ind_labels is TRUE, group by population [default TRUE].}

\item{ind_labels_size}{Size of the individual labels [default 10].}

\item{plot_colors}{Vector with four color names for homozygotes for the
reference allele, heterozygotes, homozygotes for the alternative allele and
for missing values (NA), e.g. four_colours [default NULL].
Can be set to "hetonly", which defines colors to only show heterozygotes in the genlight object}

\item{posi}{Position of the legend: “left”, “top”, “right”, “bottom” or
'none' [default = 'bottom'].}

\item{save2tmp}{If TRUE, saves plot to the session temporary directory
(tempdir) [default FALSE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report [default NULL].}
}
\value{
Returns unaltered genlight object
}
\description{
Each locus is color coded for scores of 0, 1, 2 and NA for SNP data and 0, 1
and NA for presence/absence (SilicoDArT) data. Individual labels can be added
and individuals can be grouped by population.

Plot may become cluttered if ind_labels If there are too many individuals, 
it is best to use ind_labels_size = 0.
}
\examples{
gl.smearplot(testset.gl,ind_labels=FALSE)
gl.smearplot(testset.gs[1:10,],ind_labels=TRUE)
}
\seealso{
Other Exploration/visualisation functions: 
\code{\link{gl.pcoa.plot}()},
\code{\link{gl.select.colors}()},
\code{\link{gl.select.shapes}()}
}
\author{
Custodian: Luis Mijangos -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{Exploration/visualisation functions}
