% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_methods.R
\name{Cumulate}
\alias{Cumulate}
\title{Cumulate values among siblings}
\usage{
Cumulate(node, attribute, aggFun, ...)
}
\arguments{
\item{node}{The node on which we want to cumulate}

\item{attribute}{determines what is collected. The \code{attribute} can be
\itemize{
  \item a.) the name of a \bold{field} or a \bold{property/active} of each \code{Node} in the tree, e.g. \code{acme$Get("p")} or \code{acme$Get("position")}
  \item b.) the name of a \bold{method} of each \code{Node} in the tree, e.g. \code{acme$Get("levelZeroBased")}, where e.g. \code{acme$levelZeroBased <- function() acme$level - 1}
  \item c.) a \bold{function}, whose first argument must be a \code{Node} e.g. \code{acme$Get(function(node) node$cost * node$p)}
 }}

\item{aggFun}{the aggregation function to be applied to the children's \code{attributes}}

\item{...}{any arguments to be passed on to attribute (in case it's a function)}
}
\description{
For example, you can sum up values of siblings before
this \code{Node}.
}
\examples{
data(acme)
acme$Do(function(x) x$cost <- Aggregate(x, "cost", sum), traversal = "post-order")
acme$Do(function(x) x$cumCost <- Cumulate(x, "cost", sum))
print(acme, "cost", "cumCost")

}

