% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc_rCompare.R
\name{rCompare}
\alias{rCompare}
\title{Compare two data frames}
\usage{
rCompare(dfA, dfB, keys = NA, roundDigits = NA, mismatches = NA,
  trimChars = FALSE)
}
\arguments{
\item{dfA}{data frame. The first data object. dataCompareR will attempt to coerce all data objects to data frames.}

\item{dfB}{data frame. The second data object. dataCompareR will attempt to coerce all data objects to data frames.}

\item{keys}{String. Name of identifier column(s) used to compare dfA and dfB. NA if no identifier (row order will be used instead), 
a character for a single column name, or a vector of column names to match of multiple columns}

\item{roundDigits}{Integer. If NA, numerics are not rounded before comparison. If specified, numerics are 
rounded to the specified number of decimal places using \link[base]{round}.}

\item{mismatches}{Integer. The max number of mismatches to assess, after which dataCompareR will stop (without producing an dataCompareR 
object). Designed to improve performance for large data sets.}

\item{trimChars}{Boolean. If true, strings and factors have whitespace trimmed before comparison.}
}
\value{
An dataCompareR object. 
         An S3 object containing details of the comparison between the two data objects. Can be used with \link{summary}, 
         \link{print}, \link{saveReport} and \link{generateMismatchData}
}
\description{
Compare two data frames (or objects coercible to data frames) and produce a dataCompareR object containing 
details of the matching and mismatching elements of the data. See \code{vignette("dataCompareR")} for more details.
}
\examples{
iris2 <- iris
iris2 <- iris2[1:130,]
iris2[1,1] <- 5.2
iris2[2,1] <- 5.2
rCompare(iris,iris2,key=NA)
compDetails <- rCompare(iris,iris2,key=NA, trimChars = TRUE)
print(compDetails)
summary(compDetails)

pressure2 <- pressure
pressure2[2,2] <- pressure2[2,2] + 0.01
rCompare(pressure2,pressure2,key='temperature')
rCompare(pressure2,pressure2,key='temperature', mismatches = 10)
}
\seealso{
Other dataCompareR.functions: \code{\link{generateMismatchData}},
  \code{\link{print.dataCompareRobject}},
  \code{\link{saveReport}},
  \code{\link{summary.dataCompareRobject}}
}
\concept{dataCompareR.functions}
