% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isCPR.R
\name{isCPR}
\alias{isCPR}
\title{Check if a variable consists of Danish CPR numbers}
\usage{
isCPR(v, ...)
}
\arguments{
\item{v}{A variable (vector) to check. This variable is allowed to have any class.}

\item{...}{Not in use.}
}
\value{
A \code{\link{checkResult}} with three entires:
\code{$problem} (a logical indicating whether the variable consists
of CPR numbers), \code{$message} (if a problem was found,
the following message: "Warning: The variable seems to consist of
Danish civil registration (CPR) numbers.",
otherwise "") and \code{$problemValues} (always \code{NULL}).
}
\description{
A \code{\link{checkFunction}} that checks if \code{v} consists exclusively
of valid Danish civil registration (CPR) numbers, ignoring missing values. This
function is intended for use as a precheck in \code{\link{makeDataReport}}, ensuring
that CPR numbers are not included in a \code{dataMaid} output document.
}
\examples{
CPRs <-  sapply(c("01011988", "02011987", "04052006", "01021990", "01021991",
                  "01021993", "01021994", "01021995", "01021996", "01021997",
                  "01021970", "01021971", "01021972", "01021973", "01021974"), dataMaid:::makeCPR)
nonCPRs <- c(1:10)
mixedCPRs <- c(CPRs, nonCPRs)

#identify problem
isCPR(CPRs)

#no problem as there are no CPRs
isCPR(nonCPRs)

#no problem because not ALL values are CPRs
isCPR(mixedCPRs)

}
\seealso{
\code{\link{check}}, \code{\link{allCheckFunctions}},
\code{\link{checkFunction}}, \code{\link{checkResult}}
}
