% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFromFactor.R
\name{generateFromFactor}
\alias{generateFromFactor}
\title{Recode factor}
\usage{
generateFromFactor(dataSet, cols, verbose = TRUE, drop = FALSE, ...)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{list of character column(s) name(s) of dataSet to transform. To transform all 
factors, set it to "auto".}

\item{verbose}{should the function log (logical, default to TRUE)}

\item{drop}{should \code{cols} be dropped after generation (logical, default to FALSE)}

\item{...}{Other arguments such as \code{name_separator} to separate words in new columns names
(character, default to ".")}
}
\description{
Recode factors into 3 new columns: \cr
\itemize{
\item was the value not NA, "NA", ""
\item how often this value occures
\item the order of the value (ex: M/F => 2/1 because F comes before M in alphabet)
}
}
\examples{
# Load data set
data(messy_adult)

# transform column "type_employer"
messy_adult <- generateFromFactor(messy_adult, cols = "type_employer")
head(messy_adult)

# To transform all factor columns:
messy_adult <- generateFromFactor(messy_adult, cols = "auto")
}
