% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastFunctions.r
\name{fastHandleNa}
\alias{fastHandleNa}
\title{Handle NA values}
\usage{
fastHandleNa(dataSet, set_num = 0, set_logical = FALSE, set_char = "",
  verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{set_num}{NAs replacement for numeric column, (numeric or function, default to 0)}

\item{set_logical}{NAs replacement for logical column, (logical or function, default to FALSE)}

\item{set_char}{NAs replacement for character column, (character or function, default to "")}

\item{verbose}{Should the algorithm talk (logical, default to TRUE)}
}
\value{
dataSet as a \code{\link{data.table}} with NAs replaced.
}
\description{
Handle NAs values depending on the class of the column.
}
\details{
To preserve RAM this function edits dataSet by \strong{reference}. To keep object unchanged, please use \code{\link{copy}}. \cr
If you provide a function, it will be applied to the full column. So this function should handle NAs. \cr
For factor columns, it will add NA to list of values.
}
\examples{
# Build a useful dataSet set for example
require(data.table)
dataSet <- data.table(numCol = c(1, 2, 3, NA),
                   charCol = c("", "a", NA, "c"),
                   booleanCol = c(TRUE, NA, FALSE, NA))

# To set NAs to 0, FALSE and "" (respectively for numeric, logical, character)
fastHandleNa(copy(dataSet))

# In a numeric column to set NAs as "missing"
fastHandleNa(copy(dataSet), set_char = "missing")

# In a numeric column, to set NAs to the minimum value of the column#'                    
fastHandleNa(copy(dataSet), set_num = min) # Won't work because min(c(1, NA)) = NA so put back NA
fastHandleNa(copy(dataSet), set_num = function(x)min(x,na.rm = TRUE)) # Now we handle NAs

# In a numeric column, to set NAs to the share of NAs values
rateNA <- function(x){sum(is.na(x)) / length(x)}
fastHandleNa(copy(dataSet), set_num = rateNA) 

}
