% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretization.R
\name{build_bins}
\alias{build_bins}
\title{Compute bins}
\usage{
build_bins(
  data_set,
  cols = "auto",
  n_bins = 10,
  type = "equal_width",
  verbose = TRUE
)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{cols}{List of numeric column(s) name(s) of data_set to transform. To transform all
characters, set it to "auto".  (character, default to "auto")}

\item{n_bins}{Number of group to compute (numeric, default to 10)}

\item{type}{Type of discretization ("equal_width" or "equal_freq")}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
A list where each element name is a column name of data set and each element contains
bins to discretize this column.
}
\description{
Compute bins for discretization of numeric variable (either equal_width or equal_fred).
}
\details{
Using equal freq first bin will start at -Inf and last bin will end at +Inf.
}
\examples{
# Load data
data(messy_adult)
head(messy_adult)

# Compute bins
bins <- build_bins(messy_adult, cols = "auto", n_bins = 5, type = "equal_freq")
print(bins)
}
