% Generated by roxygen2 (4.0.2): do not edit by hand
\name{importWaterML1}
\alias{importWaterML1}
\title{Function to return data from the NWISWeb WaterML1.1 service}
\usage{
importWaterML1(obs_url, asDateTime = FALSE, tz = "")
}
\arguments{
\item{obs_url}{string containing the url for the retrieval}

\item{asDateTime}{logical, if TRUE returns date and time as POSIXct, if FALSE, Date}

\item{tz}{string to set timezone attribute of datetime. Default is an empty quote, which converts the
datetimes to UTC (properly accounting for daylight savings times based on the data's provided tz_cd column).
Possible values to provide are "America/New_York","America/Chicago", "America/Denver","America/Los_Angeles",
"America/Anchorage","America/Honolulu","America/Jamaica","America/Managua","America/Phoenix", and "America/Metlakatla"}
}
\value{
mergedDF a data frame containing columns agency, site, dateTime, values, and remark codes for all requested combinations
}
\description{
This function accepts a url parameter that already contains the desired
NWIS site, parameter code, statistic, startdate and enddate.
}
\examples{
siteNumber <- "02177000"
startDate <- "2012-09-01"
endDate <- "2012-10-01"
offering <- '00003'
property <- '00060'
obs_url <- constructNWISURL(siteNumber,property,startDate,endDate,'dv')
\dontrun{
data <- importWaterML1(obs_url,TRUE)

groundWaterSite <- "431049071324301"
startGW <- "2013-10-01"
endGW <- "2014-06-30"
groundwaterExampleURL <- constructNWISURL(groundWaterSite, NA,
          startGW,endGW, service="gwlevels")
groundWater <- importWaterML1(groundwaterExampleURL)

unitDataURL <- constructNWISURL(siteNumber,property,
         "2013-11-03","2013-11-03",'uv')
unitData <- importWaterML1(unitDataURL,TRUE)

filePath <- system.file("extdata", package="dataRetrieval")
fileName <- "WaterML1Example.xml"
fullPath <- file.path(filePath, fileName)
importUserWM1 <- importWaterML1(fullPath,TRUE)

# Two sites, two pcodes, one site has two data descriptors:
siteNumber <- c('01480015',"04085427")
obs_url <- constructNWISURL(siteNumber,c("00060","00010"),startDate,endDate,'dv')
data <- importWaterML1(obs_url)
data$dateTime <- as.Date(data$dateTime)
data <- renameNWISColumns(data)
names(attributes(data))
attr(data, "url")
attr(data, "disclaimer")
}
}

