% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataops_subset.R
\name{drSubset}
\alias{drSubset}
\title{Subsetting Distributed Data Frames}
\usage{
drSubset(data, subset = NULL, select = NULL, drop = FALSE,
  preTransFn = NULL, maxRows = 500000, params = NULL, packages = NULL,
  control = NULL, verbose = TRUE)
}
\arguments{
\item{data}{object to be subsetted -- an object of class "ddf" or "ddo" - in the latter case, need to specify \code{preTransFn} to coerce each subset into a data frame}

\item{subset}{logical expression indicating elements or rows to keep: missing values are taken as false}

\item{select}{expression, indicating columns to select from a data frame}

\item{drop}{passed on to [ indexing operator}

\item{preTransFn}{a transformation function (if desired) to applied to each subset prior to division - note: this is deprecated - instead use \code{\link{addTransform}} prior to calling divide}

\item{maxRows}{the maximum number of rows to return}

\item{params}{a named list of objects external to the input data that are needed in the distributed computing (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{packages}{a vector of R package names that contain functions used in \code{fn} (most should be taken care of automatically such that this is rarely necessary to specify)}

\item{control}{parameters specifying how the backend should handle things (most-likely parameters to \code{rhwatch} in RHIPE) - see \code{\link{rhipeControl}} and \code{\link{localDiskControl}}}

\item{verbose}{logical - print messages about what is being done}
}
\value{
data frame
}
\description{
Return a subset of a "ddf" object to memory
}
\examples{
d <- divide(iris, by = "Species")
drSubset(d, Sepal.Length < 5)
}
\author{
Ryan Hafen
}

