% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{search_by_publisher}
\alias{search_by_publisher}
\title{Creates a data.frame containing datasets from datos.gob.es}
\usage{
search_by_publisher(publisher, numentry = 50, page = 0)
}
\arguments{
\item{publisher}{Publisher to search}

\item{numentry}{Number of results for page}

\item{page}{The number of page to see, the first page is 0}
}
\value{
A data.frame
}
\description{
Send a request to datos.gob.es using the publisher param
to search datasets that match with the publisher, then the results are returned
as data.frame
}
\examples{
library(dataesgobr)
\donttest{
url <- make_url("publisher", 'L01280066')
publisherID <- get_id(url)
datasets <- search_by_publisher(publisherID)
datasets2 <- search_by_publisher('L01280066')
}
}
