% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{Blogger-class}
\alias{Blogger-class}
\alias{blogger}
\title{Location Class for Google's Blogger service}
\usage{
blogger(oauthfile = getOption("blogger.oauthfile"),
  client_id = getOption("datamart.client_id"),
  client_secret = getOption("datamart.client_secret"),
  blogurl = getOption("blogger.blog"), clss = "Blogger")
}
\arguments{
\item{oauthfile}{filename of previously saved authentication information.}

\item{client_id}{client_id. See \code{google.oauth2}}

\item{client_secret}{client_secret. See \code{google.oauth2}}

\item{blogurl}{URL of the (existing) blog. Defaults to getOption("blogger.blog").}

\item{clss}{name of the class for convenient inheritance. Defaults to "Blogger".}
}
\value{
Blogger
}
\description{
This class implements a small subset of the blogger API v3.
The \code{meta} method provides information on the submitted blogposts. The \code{put} method accepts a
\code{BlogPostTarget} that can be transfered to Blogger.

Instantiates an object and authenticates with google.
If the provided \code{oauthfile} parameter points to an existing file,
the authentication information is loaded by \code{read.google.oauth2},
and the client_id and client_secret information are ignored.
If \code{oauthfile} is missing, an initial authentication (directing the
user to an website) is performed by \code{google.oauth2}.
}
\examples{
getSlots("Blogger")
}
\references{
\href{https://developers.google.com/blogger/docs/3.0/}{Blogger}
}
\seealso{
\code{\link{blogger}}, \code{\link{mdreport}}
}

