% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{psptime2}
\alias{psptime2}
\title{Remediciones en una parcela permanente de muestreo en una plantación de pino radiata (Chile).}
\format{
Los datos tienen las siguientes columnas:
\describe{
\item{plot.no}{Identificador de la parcela}	 
\item{arbol}{Identificador del árbol.}
\item{dap}{Diámetro a la altura del pecho, en cm.}
\item{anho}{Año de medicion.} 											
\item{x}{Posición Cartesiana en el eje X, en m.}
\item{y}{Posición Cartesiana en el eje Y, en m.}
\item{muerto}{si el árbol esta muerto, esta columna es igual a 1, y 0 en cualquier otro caso.}
 }
}
\source{
Los datos fueron obtenidos de los archivos disponibles en \url{https://zenodo.org/record/7341482}.
}
\usage{
data(psptime2)
}
\description{
Remediciones anuales de árboles en una parcela permanente de 1600 m\eqn{^{2}}{^2} establecida en una plantacion
 de pino insigne en Chile. Ademas, la ubicación espacial de cada árbol esta disponible.  La parcela es cuadrada (40 m × 40 m), y
 si un árbol se encontro muerto en una medicion, la columna muerto=1.
}
\examples{
data(psptime2)    
head(psptime2) 
tapply(psptime2$dap,psptime2$anho,mean)
library(lattice)
histogram(~dap|as.factor(anho), data=psptime2)
}
\references{
- Pommerening A, Trincado G, Salas-Eljatib C, Burkhart H. 2023. Understanding and modelling the dynamics of data point
 clouds of relative growth rate and plant size. Forest Ecology and 
 management Volume 529, 1206525 \doi{10.1016/j.foreco.2022.120652}
}
\keyword{datasets}
