% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{soiltreat}
\alias{soiltreat}
\title{Soil treatments on the height growth of 2-year-old seedlings.}
\format{
Contains the following columns:
\describe{
  \item{block}{Code for the corresponding block used in the experiment.} 
  \item{treat}{Treatment level.}
  \item{ini.h}{Initial height of the plot, in m.}
  \item{inc.h}{5-yr increment in height of the plot, in m.}
 }
}
\source{
The data come from page 71 of Freese (1967), and were typed by Nayeli
 Ramirez,  a student of Prof Christian Salas-Eljatib.
}
\usage{
data(soiltreat)
}
\description{
Treatments were assigned at random to the three plots within each of 11 blocks.
 Each plot was made up of 50 seedlings. Average 5-year height increment was
  the criterion for evaluating treatments. Initial heights and 5-year increments
  are part of the data.
}
\examples{
data(soiltreat)    
tapply(soiltreat$inc.h,soiltreat$treat,summary)
}
\references{
Freese F. 1967. Elementary statistical methods for foresters. Agriculture Handbook 317,
U.S. Department of Agriculture, Forest Service, Washington DC, USA. 87p.
}
\keyword{datasets}
