% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe_datas.R
\docType{data}
\name{crown2}
\alias{crown2}
\title{Radios de copa de árboles}
\format{
Contiene las siguientes columnas:
\describe{
\item{espe}{Código de especie, donde: 'Ro' es Nothofagus obliqua (Roble), 'Co' es Nothofagus dombeyi (Coigue) y 'Ol' es Olivillo.}
\item{dap}{Diámetro a la altura del pecho, en cm.}
\item{atot}{Altura total, en m.}
\item{rc.n}{Radio de copa hacia el Norte, en m.}
\item{rc.e}{Radio de copa hacia el Este, en m.}
 \item{rc.s}{Radio de copa hacia el Sur, en m.}
\item{rc.w}{Radio de copa hacia el Oeste, en m.}
\item{coord.x}{Posición cartesiana en el eje-X, en m.}
\item{coord.y}{Posición cartesiana en el eje-Y, en m.}
\item{dcopa}{Diámetro de copa, en m.}
 }
}
\source{
Datos cedidos por el Prof. Christian Salas-Eljatib, Universidad de Chile (Santiago, Chile).
}
\usage{
data(crown2)
}
\description{
Mediciones de radios de copa en direcciones cardinales para árboles muestra en Rucamanque, cerca de Temuco, Chile.
 Los datos fueron colectados al interior de una parcela de muestreo de 250 m\eqn{^{2}}{^2}, establecidad en un bosque
 secundario dominado por Nothofagus obliqua.
}
\examples{
data(crown2)    
table(crown2$espe) 
descstat(crown2[,c("dap","dcopa")])
}
\references{
- Salas C. 2001. Caracterización básica del relicto de Biodiversidad 
Rucamanque [Basic characterization of the biodiversity remnant Rucamanque]. Bosque Nativo, 29:3-9. \url{https://eljatib.com/publication/2001-06-01_caracterizacion_basi/}

- Salas C, and Garcia O. 2006. Modelling height development of mature Nothofagus obliqua. 
Forest Ecology and Management 229 (1-3): 1–6. \doi{10.1016/j.foreco.2006.04.015}
}
\keyword{datasets}
