% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SystemMetadata.R, R/DataObject.R,
%   R/DataPackage.R
\docType{methods}
\name{addAccessRule}
\alias{addAccessRule}
\alias{addAccessRule,SystemMetadata-method}
\alias{addAccessRule,DataObject-method}
\alias{addAccessRule,DataPackage-method}
\title{Add access rules to the specified object.}
\usage{
addAccessRule(x, ...)

\S4method{addAccessRule}{SystemMetadata}(x, y, ...)

\S4method{addAccessRule}{DataObject}(x, y, ...)

\S4method{addAccessRule}{DataPackage}(x, y, ...)
}
\arguments{
\item{x}{The object instance to which to add the rules}

\item{...}{Additional arguments
\itemize{
  \item{permission The permission to be applied to subject if x is character (read, write, changePermission)}
}}

\item{y}{The subject of the rule to be added, or a data frame of subject/permission tuples}
}
\value{
The SystemMetadata object with the updated access policy.

The DataObject with the updated access policy

The DataPackage with updated DataObject access policies
}
\description{
Add one or more access rules to the access policy of the specified object.
}
\details{
If the \code{y} argument is specified as a character string containing a \code{subject},
then an optional \code{permission} parameter must be specified, that contains a character list
specifying the permissions to add for each \code{subject}.

Note that when \code{addAccessRule} is called with a `DataPackage` argument, the 
additional parameter \code{identifiers} can be used:
\itemize{
  \item{identifiers A list of \code{character} values containing package member identifiers that the access rule will be appliced to (all members is the default)}.
}
}
\examples{
# Add an access rule to a SystemMetadata access policy.
# Parameter "y" can be character string containing the subject of the access rule:
sysmeta <- new("SystemMetadata")
sysmeta <- addAccessRule(sysmeta, "uid=smith,ou=Account,dc=example,dc=com", "write")
accessRules <- data.frame(subject=c("uid=smith,ou=Account,dc=example,dc=com", 
  "uid=slaughter,o=unaffiliated,dc=example,dc=org"), permission=c("write", "changePermission"))
sysmeta <- addAccessRule(sysmeta, accessRules)
# Alternatively, parameter "y" can be a data.frame containing one or more access rules:
sysmeta <- addAccessRule(sysmeta, "uid=smith,ou=Account,dc=example,dc=com", "write")
accessRules <- data.frame(subject=c("uid=smith,ou=Account,dc=example,dc=com", 
  "uid=slaughter,o=unaffiliated,dc=example,dc=org"), permission=c("write", "changePermission"))
sysmeta <- addAccessRule(sysmeta, accessRules)
# Add an access rule to a DataObject
data <- charToRaw("1,2,3\\n4,5,6\\n")
obj <- new("DataObject", id="1234", dataobj=data, format="text/csv")
obj <- addAccessRule(obj, "uid=smith,ou=Account,dc=example,dc=com", "write")
# Add an access rule to members of a DataPackage
# First create a sample DataPackage
dp <- new("DataPackage")
data <- charToRaw("1,2,3\\n4,5,6\\n")
obj <- new("DataObject", id="id1", dataobj=data, format="text/csv")
dp <- addMember(dp, obj)
data2 <- charToRaw("7,8,9\\n4,10,11\\n")
obj2 <- new("DataObject", id="id2", dataobj=data2, format="text/csv")
dp <- addMember(dp, obj2)
# Add access rule to all package members
dp <- addAccessRule(dp, "uid=smith,ou=Account,dc=example,dc=com", "write", getIdentifiers(dp))
}
\seealso{
\code{\link{SystemMetadata-class}}

\code{\link{DataObject-class}}

\code{\link{DataPackage-class}}
}
