% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DataPackage.R
\docType{methods}
\name{updateMetadata}
\alias{updateMetadata}
\alias{updateMetadata,DataPackage-method}
\title{Update selected elements of the XML content of a DataObject in a DataPackage (aka package member).}
\usage{
updateMetadata(x, do, ...)

\S4method{updateMetadata}{DataPackage}(x, do, xpath, replacement,
  newId = NA_character_, ...)
}
\arguments{
\item{x}{a DataPackage instance}

\item{do}{A DataObject instance object, or DataObject identifier}

\item{...}{(Not yet used)}

\item{xpath}{A \code{character} value specifying the location in the XML to update.}

\item{replacement}{A \code{character} value that will replace the elements found with the \code{xpath}.}

\item{newId}{A value of type \code{"character"} which will replace the identifier for this DataObject.}
}
\description{
A DataObject that contains an XML document can be edited by specifying a path
to the elements to edit (an XPath expression) and a value to replace the text node.
}
\details{
This method requires some knowledge of the structure of the metadata document as well
as facility with the XPath language. If the \code{newId} argument is used, the specified new 
identifier will be assigned to the object, and the previous identifier will be stored in the \code{oldId} slot, 
for possible use when updating the DataObject to a repository. If \code{newId} is not used, a new
identifier will be generated for the DataObject only the first time that updateMetadata is called for
a particular object in a DataPackage.
}
\examples{
# Create a DataObject and add it to the DataPackage
dp <- new("DataPackage")
sampleMeta <- system.file("./extdata/sample-eml.xml", package="datapack")
id <- "1234"
metaObj <- new("DataObject", id="1234", format="eml://ecoinformatics.org/eml-2.1.1", 
                file=sampleMeta)
dp <- addMember(dp, metaObj)

# In the metadata object, insert the newly assigned data 
xp <- sprintf("//dataTable/physical/distribution[../objectName/text()=\\"\%s\\"]/online/url", 
              "sample-data.csv") 
newURL <- sprintf("https://cn.dataone.org/cn/v2/resolve/\%s", "1234")
dp <- updateMetadata(dp, id, xpath=xp, replacement=newURL)
}
\seealso{
\code{\link{DataPackage-class}}
}
