% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_load_workbook_like_file.R
\name{prep_load_workbook_like_file}
\alias{prep_load_workbook_like_file}
\title{Pre-load a file with named (usually more than) one table(s)}
\usage{
prep_load_workbook_like_file(file)
}
\arguments{
\item{file}{the file name to load.}
}
\value{
\link{data.frame} \verb{invisible(the cache environment)}
}
\description{
These can thereafter be referred to by their names only. Such files are,
e.g., spreadsheet-workbooks or \code{RData}-files.
}
\details{
Note, that this function in contrast to \link{prep_get_data_frame} does neither
support \code{URLs} nor selecting specific sheets/columns from a file.
}
\examples{
\dontrun{
file_name <-
  system.file("extdata", "meta_data_extended.xlsx", package = "dataquieR")
prep_load_workbook_like_file(file_name)
prep_get_data_frame(
  "dataframe_level") # dataframe_level is a sheet in the file
}
}
\seealso{
\link{prep_add_data_frames}

\link{prep_get_data_frame}
}
