% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acc_margins.R
\name{acc_margins}
\alias{acc_margins}
\title{Estimate marginal means, see \link[emmeans:emmeans]{emmeans::emmeans}}
\usage{
acc_margins(
  resp_vars = NULL,
  group_vars = NULL,
  co_vars = NULL,
  threshold_type = NULL,
  threshold_value,
  min_obs_in_subgroup,
  study_data,
  meta_data,
  label_col
)
}
\arguments{
\item{resp_vars}{\link{variable} the name of the continuous measurement variable}

\item{group_vars}{\link{variable list} len=1-1. the name of the observer, device or
reader variable}

\item{co_vars}{\link{variable list} a vector of covariables, e.g. age and sex for
adjustment}

\item{threshold_type}{\link{enum} empirical | user | none. In case empirical is
chosen a multiplier of the scale measure is used,
in case of user a value of the mean or probability
(binary data) has to be defined see Implementation
and use of thresholds. In case of none, no thresholds
are displayed and no flagging of
unusual group levels is applied.}

\item{threshold_value}{\link{numeric} a multiplier or absolute value see
Implementation and use of thresholds}

\item{min_obs_in_subgroup}{\link{integer} from=0. optional argument if a
"group_var" is used.
This argument specifies the
minimum no. of observations that is
required to include a subgroup (level)
of the "group_var" in
the analysis. Subgroups with less
observations are excluded. The
default is 5.}

\item{study_data}{\link{data.frame} the data frame that contains the measurements}

\item{meta_data}{\link{data.frame} the data frame that contains metadata
attributes of study data}

\item{label_col}{\link{variable attribute} the name of the column in the metadata
with labels of variables}
}
\value{
a list with:
\itemize{
\item SummaryTable: data frame underlying the plot
\item SummaryData: data frame
\item SummaryPlot: ggplot2 margins plot
}
}
\description{
margins does calculations for quality indicator
Unexpected distribution wrt location (link). Therefore we pursue a combined
approach of descriptive and model-based statistics to investigate differences
across the levels of an auxiliary variable.

CAT: Unexpected distribution w.r.t. location

Marginal means

Marginal means rests on model based results, i.e. a significantly different
marginal mean depends on sample size. Particularly in large studies, small
and irrelevant differences may become significant. The contrary holds if
sample size is low.
}
\details{
Limitations

Selecting the appropriate distribution is complex. Dozens of continuous,
discrete or mixed distributions are conceivable in the context of
epidemiological data. Their exact exploration is beyond the scope of this
data quality approach. The function above uses the help function
\link{util_dist_selection}
which discriminates four cases:
\itemize{
\item continuous data
\item binary data
\item count data with <= 20 categories
\item count data with > 20 categories
}
Nonetheless, only three different plot types are generated. The fourth case
is treated as continuous data. This is in fact a coarsening of the original
data but for the purpose of clarity this approach is chosen.
}
\examples{
\dontrun{
# runs spuriously slow on rhub
load(system.file("extdata/study_data.RData", package = "dataquieR"))
load(system.file("extdata/meta_data.RData", package = "dataquieR"))
acc_margins(resp_vars = "DBP_0",
            study_data = study_data,
            meta_data = meta_data,
            group_vars = "USR_BP_0",
            label_col = LABEL,
            co_vars = "AGE_0")
}
}
\seealso{
\href{https://dataquality.qihs.uni-greifswald.de/VIN_acc_impl_margins.html}{Online Documentation}
}
\keyword{accuracy}
