% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util_create_page_file.R
\name{util_create_page_file}
\alias{util_create_page_file}
\title{Create an HTML file for the \link{dq_report2}}
\usage{
util_create_page_file(
  page_nr,
  pages,
  rendered_pages,
  dir,
  template_file,
  report,
  logo,
  loading,
  packageName,
  deps,
  progress_msg,
  progress,
  title,
  by_report
)
}
\arguments{
\item{page_nr}{the number of the page being created}

\item{pages}{list with all page-contents named by their desired file names}

\item{rendered_pages}{list with all rendered (\code{htmltools::renderTags}) page-contents named by their desired file names}

\item{dir}{target directory}

\item{template_file}{the report template file to use}

\item{report}{the output of \link{dq_report2}}

\item{logo}{logo \code{PNG} file}

\item{loading}{loading animation div}

\item{packageName}{the name of the current package}

\item{deps}{dependencies, as pre-processed by
\code{htmltools::copyDependencyToDir} and
\code{htmltools::renderDependencies}}

\item{progress_msg}{\link{closure} to call with progress information}

\item{progress}{\link{closure} to call with progress information}

\item{title}{\link{character} the web browser's window name}

\item{by_report}{\link{logical} this report html is part of a set of reports,
add a back-link}
}
\value{
\code{invisible(file_name)}
}
\description{
Create an HTML file for the \link{dq_report2}
}
\seealso{
Other reporting_functions: 
\code{\link{util_alias2caption}()},
\code{\link{util_copy_all_deps}()},
\code{\link{util_eval_to_dataquieR_result}()},
\code{\link{util_evaluate_calls}()},
\code{\link{util_float_index_menu}()},
\code{\link{util_generate_anchor_link}()},
\code{\link{util_generate_anchor_tag}()},
\code{\link{util_generate_calls}()},
\code{\link{util_generate_calls_for_function}()},
\code{\link{util_load_manual}()},
\code{\link{util_make_data_slot_from_table_slot}()},
\code{\link{util_make_function}()},
\code{\link{util_order_by_order}()},
\code{\link{util_set_size}()}
}
\concept{process}
\concept{reporting_functions}
\keyword{internal}
