% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateFeaturelist.R
\name{CreateModelingFeaturelist}
\alias{CreateModelingFeaturelist}
\title{This function allows the user to create a new featurelist
in a project by specifying its name and a list of variables
to be included}
\usage{
CreateModelingFeaturelist(project, listName, featureNames)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{listName}{character. String identifying the new featurelist
to be created.}

\item{featureNames}{character. Vector listing the names of the
variables to be included in the featurelist.}
}
\description{
In time series projects, a new set of modeling features is created after setting the
partitioning options. These features are automatically derived from those in the project's
dataset and are the features used for modeling. Modeling features are only accessible once
the target and partitioning options have been set. In projects that don't use time series
modeling, once the target has been set, ModelingFeaturelists and Featurelists will behave
the same.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  CreateModelingFeaturelist(projectId, "myFeaturelist", c("feature1", "feature2"))
}
}
