% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrimeModels.R
\name{GetPrimeModel}
\alias{GetPrimeModel}
\title{Retrieve information about specified DataRobot Prime model.}
\usage{
GetPrimeModel(project, modelId)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{modelId}{character. Unique alphanumeric identifier for the model of interest.}
}
\value{
list (classed as \code{dataRobotPrimeModel}) containing information
  about specified DataRobot Prime model.
}
\description{
This function requests the DataRobot Prime model information for the DataRobot
project specified by the project argument, and modelId.
}
\details{
The function returns list containing information about specified DataRobot Prime model.
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  GetPrimeModel(projectId, modelId)
}
}
