% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_title.R
\name{dataset_title}
\alias{dataset_title}
\alias{dataset_title<-}
\alias{dataset_title_create}
\title{Get/set title(s) of a dataset}
\usage{
dataset_title(x)

dataset_title(x, overwrite = FALSE) <- value

dataset_title_create(Title, titleType = "Title")
}
\arguments{
\item{x}{An R object}

\item{overwrite}{Defaults to \code{FALSE}.}

\item{value}{The name(s) or title(s) by which a resource is known. A character string or
a Title object created by \code{\link{dataset_title_create}}.Similar to
\href{https://purl.org/dc/elements/1.1/title}{dct:title}.}

\item{Title}{The name(s) or title(s) by which a resource is known, including \code{Title},
\code{AlternativeTitle},  \code{Subtitle},  \code{TranslatedTitle},  \code{OtherTitle}.
May be the title of a dataset
or the name of a piece of software.
Similar to \href{https://purl.org/dc/elements/1.1/title}{dct:title}.\cr
Use \code{\link{dataset_title_create}} to create a several title entries.}

\item{titleType}{In DataCite, the controlled values are
\code{AlternativeTitle}, \code{Subtitle}, \code{TranslatedTitle}, \code{Other}. When no titleType is given (as in
Dublin Core), the titleType is set to \code{Title}.}
}
\value{
The titles as a data.frame with a titleTypes column.
}
\description{
Add one or more \code{Title(s)} to the dataset's metadata.
}
\details{
In the DataCite definition, several titles can be used.
}
\examples{
my_iris <- iris

dataset_title(my_iris) <- dataset_title_create(
    Title = c("Iris Dataset",
    "The famous iris dataset of the R examples"),
    titleType = c("Title", "Subtitle")
    )
dataset_title(my_iris)

 y <- data.frame()
 dataset_title(y) <- "R (Computer program language)"
 dataset_title(y) <- "Questionnaires--Computer programs"
 dataset_title(y)
}
