% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_bibentry.R
\name{dataset_bibentry}
\alias{dataset_bibentry}
\title{Get the bibliographic entries of a dataset}
\usage{
dataset_bibentry(x)
}
\arguments{
\item{x}{A dataset object created with \code{dataset::\link{dataset}}.}
}
\value{
The \code{\link[utils]{bibentry}} object of the dataset.
}
\description{
A dataset constructed with \code{\link{dataset}} records most of the
dataset-level metadata in a \code{bibentry} object.
A dataset constructed with \code{\link{dataset}} records most of the
dataset-level metadata in a bibentry object. This class is defined in the
\emph{utils} package, and it is installed by default with R;
using the gives wide interoperability with other packages and allows
printing or saving the bibliographic record in HTML, BibLatex and other
formats. For further information see \code{utils::\link[utils]{bibentry}}.
}
\examples{
ds <- dataset(iris,
        title = "The iris Dataset",
        author = c(
           person(family ="Anderson",
                  given ="Edgar",
                  role = "aut")
                 ),
         identifier = "https://doi.org/10.1111/j.1469-1809.1936.tb02137.x",
         year = "1935",
         version = "1.0",
         description = "The famous dataset that is distributed with R.",
         url = "https://en.wikipedia.org/wiki/Iris_flower_data_set",
         resourceType = "Dataset"
         )

dataset_bibentry(ds)
}
