% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/description.R
\name{description}
\alias{description}
\alias{description<-}
\title{Get/set the Description of the object.}
\usage{
description(x)

description(x, overwrite = FALSE) <- value
}
\arguments{
\item{x}{A dataset object created with \code{dataset::\link{dataset}}.}

\item{overwrite}{If the \code{Description} attribute should be overwritten. In case it is set to \code{FALSE},
it gives a message with the current \code{Description} property instead of overwriting it.
Defaults to \code{FALSE}, when it gives a warning at an accidental overwrite attempt.}

\item{value}{The \code{Description} as a character set.}
}
\value{
The \code{Description} attribute as a character of length 1 is added to \code{x}.
}
\description{
Get/set the optional \code{Description} property as an attribute to an R object.
}
\details{
The \code{Description} is recommended for discovery in DataCite. All additional information that does not
fit in any of the other categories. May be used for technical information. A free text.
Similar to \href{https://purl.org/dc/elements/1.1/description}{dct:description}.
}
\examples{
description(iris_dataset, overwrite = TRUE) <- "The famous iris dataset used
in R language examples."
description(iris_dataset)
}
\seealso{
Other Reference metadata functions: 
\code{\link{creator}()},
\code{\link{datasource}()},
\code{\link{geolocation}()},
\code{\link{identifier}()},
\code{\link{language}},
\code{\link{publication_year}()},
\code{\link{publisher}()},
\code{\link{rights}()},
\code{\link{size}()},
\code{\link{version}()}
}
\concept{Reference metadata functions}
