% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SWORD_dataset.R
\name{dataset_atom}
\alias{dataset_atom}
\alias{dataset_statement}
\title{View dataset (SWORD)}
\usage{
dataset_atom(
  dataset,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)

dataset_statement(
  dataset,
  key = Sys.getenv("DATAVERSE_KEY"),
  server = Sys.getenv("DATAVERSE_SERVER"),
  ...
)
}
\arguments{
\item{dataset}{A dataset DOI (or other persistent identifier), an object of class \dQuote{dataset_atom} or \dQuote{dataset_statement}, or an appropriate and complete SWORD URL.}

\item{key}{A character string specifying a Dataverse server API key. If one
is not specified, functions calling authenticated API endpoints will fail.
Keys can be specified atomically or globally using
\code{Sys.setenv("DATAVERSE_KEY" = "examplekey")}.}

\item{server}{A character string specifying a Dataverse server. There are
multiple Dataverse installations, but the defaults is to use the Harvard
Dataverse (\code{server = "dataverse.harvard.edu"}). This can be modified atomically
or globally using \code{Sys.setenv("DATAVERSE_SERVER" = "dataverse.example.com")}.}

\item{...}{Additional arguments passed to an HTTP request function, such as
\code{\link[httr]{GET}}, \code{\link[httr]{POST}}, or
\code{\link[httr]{DELETE}}.}
}
\value{
A list. For \code{dataset_atom}, an object of class \dQuote{dataset_atom}.
}
\description{
View a SWORD (possibly unpublished) dataset \dQuote{statement}
}
\details{
These functions are used to view a dataset by its persistent identifier. \code{dataset_statement} will contain information about the contents of the dataset, whereas \code{dataset_atom} contains \dQuote{metadata} relevant to the SWORD API.
}
\examples{
\dontrun{
# retrieve your service document
d <- service_document()

# retrieve dataset statement (list contents)
dataset_statement(d[[2]])

# retrieve dataset atom
dataset_atom(d[[2]])
}
}
\seealso{
Managing a Dataverse: \code{\link{publish_dataverse}}; Managing a dataset: \code{\link{dataset_atom}}, \code{\link{list_datasets}}, \code{\link{create_dataset}}, \code{\link{delete_sword_dataset}}, \code{\link{publish_dataset}}; Managing files within a dataset: \code{\link{add_file}}, \code{\link{delete_file}}
}
