% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_extract.R
\name{data_extract}
\alias{data_extract}
\alias{data_extract.data.frame}
\title{Extract one or more columns or elements from an object}
\usage{
data_extract(data, select, ...)

\method{data_extract}{data.frame}(
  data,
  select,
  name = NULL,
  extract = "all",
  as_data_frame = FALSE,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{The object to subset. Methods are currently available for data frames
and data frame extensions (e.g., tibbles).}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with()}, \code{ends_with()},
\code{contains()}, a range using \code{:} or \code{regex("")}. \code{starts_with()},
\code{ends_with()}, and  \code{contains()} accept several patterns, e.g
\code{starts_with("Sep", "Petal")}.
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-(Sepal.Width:Petal.Length)}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{extract_column_names(iris, select = c("Species", "Test"))}
will just return \code{"Species"}.}

\item{...}{For use by future methods.}

\item{name}{An optional argument that specifies the column to be used as
names for the vector elements after extraction. Must be specified either
as literal variable name (e.g., \code{column_name}) or as string
(\code{"column_name"}). \code{name} will be ignored when a data frame is returned.}

\item{extract}{String, indicating which element will be extracted when \code{select}
matches multiple variables. Can be \code{"all"} (the default) to return all
matched variables, \code{"first"} or \code{"last"} to return the first or last match,
or \code{"odd"} and \code{"even"} to return all odd-numbered or even-numbered
matches. Note that \code{"first"} or \code{"last"} return a vector (unless
\code{as_data_frame = TRUE}), while \code{"all"} can return a vector (if only one
match was found) \emph{or} a data frame (for more than one match). Type safe
return values are only possible when \code{extract} is \code{"first"} or \code{"last"} (will
always return a vector) or when \code{as_data_frame = TRUE} (always returns a
data frame).}

\item{as_data_frame}{Logical, if \code{TRUE}, will always return a data frame,
even if only one variable was matched. If \code{FALSE}, either returns a vector
or a data frame. See \code{extract} for details.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{regex}{Logical, if \code{TRUE}, the search pattern from \code{select} will be
treated as regular expression. When \code{regex = TRUE}, select \emph{must} be a
character string (or a variable containing a character string) and is not
allowed to be one of the supported select-helpers or a character vector
of length > 1. \code{regex = TRUE} is comparable to using one of the two
select-helpers, \code{select = contains("")} or \code{select = regex("")}, however,
since the select-helpers may not work when called from inside other
functions (see 'Details'), this argument may be used as workaround.}

\item{verbose}{Toggle warnings.}
}
\value{
A vector (or a data frame) containing the extracted element, or
\code{NULL} if no matching variable was found.
}
\description{
\code{data_extract()} (or its alias \code{extract()}) is similar to \code{$}. It extracts
either a single column or element from an object (e.g., a data frame, list),
or multiple columns resp. elements.
}
\details{
\code{data_extract()} can be used to select multiple variables or pull a
single variable from a data frame. Thus, the return value is by default not
type safe - \code{data_extract()} either returns a vector or a data frame.
\subsection{Extracting single variables (vectors)}{
When \code{select} is the name of a single column, or when select only matches
one column, a vector is returned. A single variable is also returned when
\code{extract} is either \verb{"first} or \code{"last"}. Setting \code{as_data_frame} to \code{TRUE}
overrides this behaviour and \emph{always} returns a data frame.
}
\subsection{Extracting a data frame of variables}{
When \code{select} is a character vector containing more than one column name (or
a numeric vector with more than one valid column indices), or when \code{select}
uses one of the supported select-helpers that match multiple columns, a
data frame is returned. Setting \code{as_data_frame} to \code{TRUE} \emph{always} returns
a data frame.
}
}
\examples{
# single variable
data_extract(mtcars, cyl, name = gear)
data_extract(mtcars, "cyl", name = gear)
data_extract(mtcars, -1, name = gear)
data_extract(mtcars, cyl, name = 0)
data_extract(mtcars, cyl, name = "row.names")

# selecting multiple variables
head(data_extract(iris, starts_with("Sepal")))
head(data_extract(iris, ends_with("Width")))
head(data_extract(iris, 2:4))

# select first of multiple variables
data_extract(iris, starts_with("Sepal"), extract = "first")

# select first of multiple variables, return as data frame
head(data_extract(iris, starts_with("Sepal"), extract = "first", as_data_frame = TRUE))
}
