% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makepredictcall.R
\name{makepredictcall.dw_transformer}
\alias{makepredictcall.dw_transformer}
\title{Utility Function for Safe Prediction with \code{datawizard} transformers}
\usage{
\method{makepredictcall}{dw_transformer}(var, call)
}
\arguments{
\item{var}{A variable.}

\item{call}{The term in the formula, as a call.}
}
\value{
A replacement for \code{call} for the \code{predvars} attribute of
  the terms.
}
\description{
This function allows for the use of (some of) \code{datawizard}'s transformers
inside a model formula. See examples below.
\cr\cr
Currently, \code{\link[=center]{center()}}, \code{\link[=standardize]{standardize()}}, \code{\link[=normalize]{normalize()}}, & \code{\link[=rescale]{rescale()}} are
supported.
}
\examples{

data("mtcars")
train <- mtcars[1:30, ]
test <- mtcars[31:32, ]

m1 <- lm(mpg ~ center(hp), data = train)
predict(m1, newdata = test) # Data is "centered" before the prediction is made,
# according to the center of the old data

m2 <- lm(mpg ~ standardize(hp), data = train)
m3 <- lm(mpg ~ scale(hp), data = train) # same as above
predict(m2, newdata = test) # Data is "standardized" before the prediction is made.
predict(m3, newdata = test) # Data is "standardized" before the prediction is made.


m4 <- lm(mpg ~ normalize(hp), data = mtcars)
m5 <- lm(mpg ~ rescale(hp, to = c(-3, 3)), data = mtcars)

(newdata <- data.frame(hp = c(range(mtcars$hp), 400))) # 400 is outside original range!

model.frame(delete.response(terms(m4)), data = newdata)
model.frame(delete.response(terms(m5)), data = newdata)

}
\seealso{
\code{\link[stats:makepredictcall]{stats::makepredictcall()}}
}
\concept{datawizard-transformers}
