% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_find.R, R/data_select.R
\name{find_columns}
\alias{find_columns}
\alias{data_find}
\alias{data_findcols}
\alias{get_columns}
\alias{data_select}
\title{Find or get columns in a data frame based on search patterns}
\usage{
find_columns(
  data,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)

data_find(
  data,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)

data_findcols(
  data,
  pattern = NULL,
  starts_with = NULL,
  ends_with = NULL,
  ignore_case = FALSE,
  ...
)

get_columns(
  data,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)

data_select(
  data,
  select = NULL,
  exclude = NULL,
  ignore_case = FALSE,
  regex = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{select}{Variables that will be included when performing the required
tasks. Can be either
\itemize{
\item a variable specified as a literal variable name (e.g., \code{column_name}),
\item a string with the variable name (e.g., \code{"column_name"}), or a character
vector of variable names (e.g., \code{c("col1", "col2", "col3")}),
\item a formula with variable names (e.g., \code{~column_1 + column_2}),
\item a vector of positive integers, giving the positions counting from the left
(e.g. \code{1} or \code{c(1, 3, 5)}),
\item a vector of negative integers, giving the positions counting from the
right (e.g., \code{-1} or \code{-1:-3}),
\item one of the following select-helpers: \code{starts_with("")}, \code{ends_with("")},
\code{contains("")}, a range using \code{:} or \code{regex("")},
\item or a function testing for logical conditions, e.g. \code{is.numeric()} (or
\code{is.numeric}), or any user-defined function that selects the variables
for which the function returns \code{TRUE} (like: \code{foo <- function(x) mean(x) > 3}),
\item ranges specified via literal variable names, select-helpers (except
\code{regex()}) and (user-defined) functions can be negated, i.e. return
non-matching elements, when prefixed with a \code{-}, e.g. \code{-ends_with("")},
\code{-is.numeric} or \code{-Sepal.Width:Petal.Length}. \strong{Note:} Negation means
that matches are \emph{excluded}, and thus, the \code{exclude} argument can be
used alternatively. For instance, \code{select=-ends_with("Length")} (with
\code{-}) is equivalent to \code{exclude=ends_with("Length")} (no \code{-}). In case
negation should not work as expected, use the \code{exclude} argument instead.
}

If \code{NULL}, selects all columns. Patterns that found no matches are silently
ignored, e.g. \code{find_columns(iris, select = c("Species", "Test"))} will just
return \code{"Species"}.}

\item{exclude}{See \code{select}, however, column names matched by the pattern
from \code{exclude} will be excluded instead of selected. If \code{NULL} (the default),
excludes no columns.}

\item{ignore_case}{Logical, if \code{TRUE} and when one of the select-helpers or
a regular expression is used in \code{select}, ignores lower/upper case in the
search pattern when matching against variable names.}

\item{regex}{Logical, if \code{TRUE}, the search pattern from \code{select} will be
treated as regular expression. When \code{regex = TRUE}, select \emph{must} be a
character string (or a variable containing a character string) and is not
allowed to be one of the supported select-helpers or a character vector
of length > 1. \code{regex = TRUE} is comparable to using one of the two
select-helpers, \code{select = contains("")} or \code{select = regex("")}, however,
since the select-helpers may not work when called from inside other
functions (see 'Details'), this argument may be used as workaround.}

\item{verbose}{Toggle warnings.}

\item{...}{Arguments passed down to other functions. Mostly not used yet.}

\item{pattern}{A regular expression (as character string), representing the
pattern to be matched in the in column names. Can also be one of the
following select-helpers: \code{starts_with("")}, \code{end_with("")}, \code{regex("")},
\code{contains("")}, or a range using \code{:}.}

\item{starts_with, ends_with}{Character string, containing the string to be
matched in the column names. \code{starts_with} finds matches at the beginning
of column names, \code{ends_with} finds matches at the end of column names.}
}
\value{
\code{find_columns()} returns a character vector with column names that
matched the pattern in \code{select} and \code{exclude}, or \code{NULL} if no matching
column name was found. \code{get_columns()} returns a data frame with matching
columns.
}
\description{
\code{find_columns()} returns column names from a data set that
match a certain search pattern, while \code{get_columns()} returns the found data.
\code{data_select()} is an alias for \code{get_columns()}, and \code{data_find()} is an alias
for \code{find_columns()}.
}
\details{
Note that there are some limitations when calling this from inside
other functions. The following will work as expected, returning all columns
that start with \code{"Sep"}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{foo <- function(data) \{
  find_columns(data, select = starts_with("Sep"))
\}
foo(iris)
}\if{html}{\out{</div>}}

However, this example won't work as expected!

\if{html}{\out{<div class="sourceCode">}}\preformatted{foo <- function(data) \{
  i <- "Sep"
  find_columns(data, select = starts_with(i))
\}
foo(iris)
}\if{html}{\out{</div>}}

One workaround is to use the \code{regex} argument, which provides at
least a bit more flexibility than exact matching. \code{regex} in its basic
usage (as seen below) means that \code{select} behaves like the \code{contains("")}
select-helper, but can also make the function more flexible by allowing to
define complex regular expression pattern in \code{select}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{foo <- function(data) \{
  i <- "Sep"
  find_columns(data, select = i, regex = TRUE)
\}
foo(iris)
}\if{html}{\out{</div>}}
}
\note{
\code{data_findcols()} is deprecated and will be fully replaced by
\code{find_columns()} in a future update.
}
\examples{
# Find columns names by pattern
find_columns(iris, starts_with("Sepal"))
find_columns(iris, ends_with("Width"))
find_columns(iris, regex("\\\\."))
find_columns(iris, c("Petal.Width", "Sepal.Length"))

# starts with "Sepal", but not allowed to end with "width"
find_columns(iris, starts_with("Sepal"), exclude = contains("Width"))

# find numeric with mean > 3.5
numeric_mean_35 <- function(x) is.numeric(x) && mean(x, na.rm = TRUE) > 3.5
find_columns(iris, numeric_mean_35)
}
\seealso{
\itemize{
\item Functions to rename stuff: \code{\link[=data_rename]{data_rename()}}, \code{\link[=data_rename_rows]{data_rename_rows()}}, \code{\link[=data_addprefix]{data_addprefix()}}, \code{\link[=data_addsuffix]{data_addsuffix()}}
\item Functions to reorder or remove columns: \code{\link[=data_reorder]{data_reorder()}}, \code{\link[=data_relocate]{data_relocate()}}, \code{\link[=data_remove]{data_remove()}}
\item Functions to reshape, pivot or rotate dataframes: \code{\link[=data_to_long]{data_to_long()}}, \code{\link[=data_to_wide]{data_to_wide()}}, \code{\link[=data_rotate]{data_rotate()}}
\item Functions to recode data: \code{\link[=data_rescale]{data_rescale()}}, \code{\link[=data_reverse]{data_reverse()}}, \code{\link[=data_cut]{data_cut()}}, \code{\link[=data_recode]{data_recode()}}, \code{\link[=data_shift]{data_shift()}}
\item Functions to standardize, normalize, rank-transform: \code{\link[=center]{center()}}, \code{\link[=standardize]{standardize()}}, \code{\link[=normalize]{normalize()}}, \code{\link[=ranktransform]{ranktransform()}}, \code{\link[=winsorize]{winsorize()}}
\item Split and merge dataframes: \code{\link[=data_partition]{data_partition()}}, \code{\link[=data_merge]{data_merge()}}
\item Functions to find or select columns: \code{\link[=data_select]{data_select()}}, \code{\link[=data_find]{data_find()}}
\item Functions to filter rows: \code{\link[=data_match]{data_match()}}, \code{\link[=data_filter]{data_filter()}}
}
}
