% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cempre.R
\encoding{UTF-8}
\name{load_cempre}
\alias{load_cempre}
\title{CEMPRE - Central Register of Companies}
\usage{
load_cempre(
  dataset = "cempre",
  raw_data,
  geo_level,
  time_period,
  language = "eng",
  sectors = FALSE,
  legal_amazon_only = FALSE
)
}
\arguments{
\item{dataset}{A dataset name ("cempre").}

\item{raw_data}{A \code{boolean} setting the return of raw (\code{TRUE}) or processed (\code{FALSE}) data.}

\item{geo_level}{A \code{string} that defines the geographic level of the data. Can be one of "country", "state" or "municipality". See documentation of \code{sidrar}.}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY. Can be a sequence of numbers such as 2010:2012.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese ("pt") and English ("eng") are supported. Defaults to "eng".}

\item{sectors}{A \code{boolean} that defines if the data will be return separated by sectors (\code{TRUE}) or not (\code{FALSE}). Defaults to \code{FALSE}}

\item{legal_amazon_only}{A \code{boolean} setting the return of Legal Amazon Data (\code{TRUE}) or Country's Data (\code{FALSE}). Defaults to \code{FALSE}}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information on companies and other organizations and their respective formally constituted local units, registered with the CNPJ - National Register of Legal Entities. Data is available from 2006 to 2019. See \url{https://sidra.ibge.gov.br/pesquisa/cempre/tabelas}
}
\examples{
\dontrun{
# download raw data from 2006 to 2019
raw_cempre_all <- load_cempre(
  dataset = "cempre",
  raw_data = TRUE,
  geo_level = "municipality",
  time_period = 2006:2019
)
}

}
