% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.datelifeResult}
\alias{summary.datelifeResult}
\title{Summarize a \code{datelifeResult} object.}
\usage{
\method{summary}{datelifeResult}(object, datelife_query, na_rm = TRUE, ...)
}
\arguments{
\item{object}{An object of class \code{datelifeResult}, usually an output of \code{\link[=get_datelife_result]{get_datelife_result()}}.}

\item{datelife_query}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}

\item{na_rm}{Default to \code{TRUE}, whether to include partial matches or not.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A named \code{list} of 11 elements:
\describe{
\item{"citations"}{A character vector of references where chronograms with
some or all of the target taxa are published (source chronograms).}
\item{"mrca"}{A named numeric vector of most recent common ancestor (mrca)
ages of target taxa defined in input, obtained from the source chronograms.
Names of mrca vector are equal to citations.}
\item{"newick_all"}{A named character vector of newick strings corresponding
to target chronograms derived from source chronograms. Names of newick_all
vector are equal to citations.}
\item{"newick_sdm"}{Only if multiple source chronograms are available. A
character vector with a single newick string corresponding to a target
chronogram obtained with SDM supertree method (Criscuolo et al. 2006).}
\item{"newick_median"}{Only if multiple source chronograms are available.
A character vector with a single newick string corresponding to a target
chronogram from the median of all source chronograms.}
\item{"phylo_sdm"}{Only if multiple source chronograms are available. A
phylo object with a single target chronogram obtained with SDM supertree
method (Criscuolo et al. 2006).}
\item{"phylo_median"}{Only if multiple source chronograms are available. A
phylo object with a single target chronogram obtained from source
chronograms with median method.}
\item{"phylo_all"}{A named list of phylo objects corresponding to each target
chronogram obtained from available source chronograms. Names of
phylo_all list correspond to citations.}
\item{"phylo_biggest"}{The chronogram with the most taxa. In the case of a
tie, the chronogram with clade age closest to the median age of the
equally large trees is returned.}
\item{"html"}{A character vector with an html string that can be saved and
then opened in any web browser. It contains a 4 column table with data on
target taxa: mrca, number of taxa, citations of source chronogram and
newick target chronogram.}
\item{"data_frame"}{A 4 column \code{data.frame} with data on target taxa: mrca, number of
taxa, citations of source chronograms and newick string.}
}
}
\description{
Summarize a \code{datelifeResult} object.
}
