% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timezone.r
\name{datetime_at_tz}
\alias{datetime_at_tz}
\alias{datetime_at_tz.datetimeoffset}
\alias{datetime_at_tz.clock_zoned_time}
\alias{datetime_at_tz.POSIXt}
\alias{datetime_at_tz.default}
\title{Change time zones while preserving UTC time}
\usage{
datetime_at_tz(x, tz = "", ...)

\method{datetime_at_tz}{datetimeoffset}(
  x,
  tz = "",
  ...,
  ambiguous = "error",
  nonexistent = "error",
  fill = NA_character_
)

\method{datetime_at_tz}{clock_zoned_time}(x, tz = "", ...)

\method{datetime_at_tz}{POSIXt}(x, tz = "", ...)

\method{datetime_at_tz}{default}(x, tz = "", ...)
}
\arguments{
\item{x}{A datetime object.}

\item{tz}{The target timezone to change to.}

\item{...}{Ignored}

\item{ambiguous}{What to do when the "clock time" in the new time zone is ambiguous.
See \code{\link[clock:as-zoned-time-naive-time]{clock::as_zoned_time.clock_naive_time()}}.}

\item{nonexistent}{What to do when the "clock time" in the new time zone doesn't exist.
See \code{\link[clock:as-zoned-time-naive-time]{clock::as_zoned_time.clock_naive_time()}}.}

\item{fill}{If timezone and UTC offset info is missing what
timezone to assume.  See \code{\link[=fill_tz]{fill_tz()}}.}
}
\value{
A datetime object.  The UTC time should be the same but with a different time zone.
}
\description{
\code{datetime_at_tz()} changes time zones while preserving UTC time (instead of clock time).
}
\examples{
if(all(c("America/Los_Angeles", "America/New_York") \%in\% OlsonNames())) {
  dt0 <- as_datetimeoffset("2020-01-01T01:01[America/Los_Angeles]")
  dt <- datetime_at_tz(dt0, "America/New_York")
  print(dt)
  dt <- datetime_at_tz(as.POSIXct(dt0), "America/New_York")
  print(dt)
  dt <- datetime_at_tz(clock::as_zoned_time(dt0), "America/New_York")
  print(dt)

  # Can also use `lubridate::with_tz()`
  if (require("lubridate")) {
    dt <- lubridate::with_tz(dt0, "America/New_York")
    print(dt)
  }
}
}
\seealso{
\code{\link[=set_tz]{set_tz()}} changes time zones while preserving clock time (instead of UTC time).
}
