# Distance Based Measures of Spatial Structures <img src="man/figures/logo.png" align="right" alt="" width="120" />

[![CRAN version](http://www.r-pkg.org/badges/version/dbmss)](https://CRAN.r-project.org/package=dbmss)
[![](http://cranlogs.r-pkg.org/badges/dbmss)](https://CRAN.R-project.org/package=dbmss)
![R-CMD-check](https://github.com/EricMarcon/dbmss/workflows/R-CMD-check/badge.svg)
[![codecov](https://codecov.io/github/EricMarcon/dbmss/branch/master/graphs/badge.svg)](https://codecov.io/github/EricMarcon/dbmss)
[![CodeFactor](https://www.codefactor.io/repository/github/ericmarcon/dbmss/badge)](https://www.codefactor.io/repository/github/ericmarcon/dbmss)

dbmss is an R package for simple computation of spatial statistic functions of distance to characterize the spatial structures of mapped objects, including classical ones (Ripley's *K* and others) and more recent ones used by spatial economists (Duranton and Overman's *Kd*, Marcon and Puech's *M*). It relies on spatstat for some core calculation.

# Vignettes

A quick [introduction](https://EricMarcon.github.io/dbmss/) is in `vignette("dbmss")`.

A [full documentation](https://ericmarcon.github.io/dbmss/articles/articles/reference.html) is available on the package website.
It is a continuous update of the paper published in the Journal of Statistical Software ([Marcon et al., 2015](https://www.jstatsoft.org/article/view/v067c03)).

## Reference

Marcon, E., Traissac, S., Puech, F. and Lang, G. (2015). Tools to Characterize Point Patterns: dbmss for R. 
*Journal of Statistical Software*. 67(3): 1-15.
