% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drug_parsers.R
\name{parse_drug_food_interactions}
\alias{parse_drug_food_interactions}
\title{Extracts the drug food interactions element and return data as tibble.}
\usage{
parse_drug_food_interactions(save_table = FALSE)
}
\arguments{
\item{save_table}{boolean, save table in database if true.}
}
\value{
drug food interactions node attributes tibble
}
\description{
\code{parse_drug_food_interactions} returns tibble of drug food
interactions elements.
}
\details{
This functions extracts the food interactions element of drug node in drugbank
xml database with the option to save it in a predefined database via
\code{\link{open_db}} method. It takes one single optional argument to
save the returned tibble in the database.
It must be called after \code{\link{get_xml_db_rows}} function like
any other parser function.
If \code{\link{get_xml_db_rows}} is called before for any reason, so
no need to call it again before calling this function.
}
\examples{
\donttest{
parse_drug_food_interactions()
parse_drug_food_interactions(TRUE)
parse_drug_food_interactions(save_table = FALSE)
}
}
