% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbbin.R
\name{db_bin}
\alias{db_bin}
\title{Bin formula}
\usage{
db_bin(var, bins = 30, binwidth = NULL)
}
\arguments{
\item{var}{Variable name or formula}

\item{bins}{Number of bins. Defaults to 30.}

\item{binwidth}{Single value that sets the side of the bins, it overrides bins}
}
\description{
Uses the rlang package to build the formula needed to create the bins of a numeric variable
in an unevaluated fashion.  This way, the formula can be then passed inside a dplyr
verb.
}
\examples{

 library(dplyr)

  # Important: Always name the field and
  # prefix the function with `!!`` (See Details)

  # Uses the default 30 bins
  mtcars \%>\%
    group_by(x = !! db_bin(mpg)) \%>\%
    tally()

  # Uses binwidth which overrides bins
  mtcars \%>\%
    group_by(x = !! db_bin(mpg, binwidth = 10)) \%>\%
    tally()

}
