% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dcBuildOnto}
\alias{dcBuildOnto}
\title{Function to build an object of the S4 class Onto from input files}
\usage{
dcBuildOnto(relations.file, nodes.file, output.file = "Onto.RData")
}
\arguments{
\item{relations.file}{an input file containing term relations (i.e.
edges from parent terms to child terms). For example, a file containing
relations between GO Molecular Function (GOMF) terms can be found in
\url{http://dcgor.r-forge.r-project.org/data/onto/igraph_GOMF_edges.txt}.
As seen in this example, the input file must contain the header (in the
first row) and two columns: 1st column for parent term ID, and 2nd
column for child term ID. Note: the file should use the tab delimiter
as the field separator between columns}

\item{nodes.file}{an input file containing term/node information. For
example, a file containing GO Molecular Function (GOMF) terms can be
found in
\url{http://dcgor.r-forge.r-project.org/data/onto/igraph_GOMF_nodes.txt}.
As seen in this example, the input file must contain the header (in the
first row) and five columns: 1st column 'name' for node names (actually
term ID; must be unique), 2nd column 'term_id' for term ID, 3rd
'term_name' for term name, 4th column 'term_namespace' for term
namespace, and 5th column 'term_distance' for term distance. These five
columns must be provided, the content in the first two columns are
identical, and the content for the last column can be arbitrary (if it
is hard to prepare). Note: the file should use the tab delimiter as the
field separator between columns}

\item{output.file}{an output file used to save the built object as an
RData-formatted file. If NULL, this file will be saved into
"Onto.RData" in the current working local directory}
}
\value{
Any use-specified variable that is given on the right side of the
assigement sign '<-', which contains the built \code{Onto} object.
Also, an RData file specified in "output.file" is saved in the local
directory.
}
\description{
\code{dcBuildOnto} is supposed to build an object of of the S4 class
\code{\link{Onto}}, given input files. These input files include 1) a
file containing term relations, and 2) a file containing term/node
information.
}
\note{
If there are no use-specified variable that is given on the right side
of the assigement sign '<-', then no object will be loaded onto the
working environment.
}
\examples{
\dontrun{
# build an "Onto" object for GO Molecular Function
onto.GOMF <-
dcBuildOnto(relations.file="http://dcgor.r-forge.r-project.org/data/onto/igraph_GOMF_edges.txt",
nodes.file="http://dcgor.r-forge.r-project.org/data/onto/igraph_GOMF_nodes.txt",
output.file="onto.GOMF.RData")
onto.GOMF
}
}
\seealso{
\code{\link{Onto}}
}

