#' Run the Shiny application
#'
#' @param ... Additional golem options passed to [golem::with_golem_options()]
#' @export
#' @return Shiny app with additional golem options passed via `...`
#' @importFrom shiny shinyApp
#' @importFrom golem with_golem_options
#' @examples
#' \dontrun{
#' library("dccvalidator")
#' run_app()
#' }
run_app <- function(...) {
  with_golem_options(
    app = shinyApp(ui = app_ui, server = app_server),
    golem_opts = list(...)
  )
}
