\name{run_checks}
\alias{run_checks}
\alias{wrapddepn}
\alias{cls}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
DDEPN function tests.
}
\description{
Perform function tests for the different inference types and prior models.
}
\usage{
run_checks(outfile = NULL, plotresults = TRUE)

wrapddepn(dataset, phit, stimuli, debug=FALSE, plotresults=TRUE, ...)
 
cls()

}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{outfile}{String. A file name giving the file where output plots should be stored. If NULL,
   the user is asked for a file name via CLI. Unused, if \code{plotresults=FALSE}.}
  \item{plotresults}{Boolean. If TRUE, result plots are generated for each test and stored in 
   file \code{outfile}. If FALSE, plots are omitted.}
  \item{dataset}{A sample dataset, e.g. generated by \code{\link{makedata}}.}
  \item{phit}{A sample network adjacency matrix, e.g. generated by \code{\link{signalnetwork}}.}
  \item{stimuli}{A list with sample stimuli, e.g. generated by \code{\link{signalnetwork}}.}
  \item{debug}{Boolean. Debug mode switch.}
  \item{\dots}{Further arguments passed to the \code{\link{ddepn}} call.}
}
\details{
  \describe{
    \item{\code{run_checks}}{
      Run a set of tests to check whether all ddepn functions are working. The following tests are performed:\cr
      \tabular{ll}{
       [1] \tab "GA, BIC optimisation"\cr                                 
       [2] \tab "GA, uniform prior"\cr                                 
       [3] \tab "GA, laplaceinhib, two types, lambda fix"\cr              
       [4] \tab "GA, laplaceinhib, two types, lambda integrated"\cr       
       [5] \tab "GA, laplace, one type, lambda fix"\cr                    
       [6] \tab "GA, laplace, one type, lambda integrated"\cr             
       [7] \tab "GA, scalefree"\cr                                        
       [8] \tab "inhibMCMC, uniform prior"\cr                             
       [9] \tab "inhibMCMC, laplaceinhib, two types, lambda fix"\cr       
      [10] \tab "inhibMCMC, laplaceinhib, two types, lambda integrated"\cr
      [11] \tab "inhibMCMC, laplace, one type, lambda fix"\cr             
      [12] \tab "inhibMCMC, laplace, one type, lambda integrated"\cr      
      [13] \tab "inhibMCMC, scalefree"\cr
      [14] \tab "inhibMCMC, laplaceinhib, two types, sample lambda"\cr
      }
    }
    
    \item{wrapddepn}{
      A simple ddepn wrap function defining a default call of \code{\link{ddepn}} for the checks.
    }
    \item{cls}{
      Function for clearing the R-console.
    }
  }
}
\value{
Matrix with the test results, where the first column holds the test and the second the result (passed or failed).
}
\author{
Christian Bender
}
\examples{
\dontrun{
library(ddepn)
tests <- run_checks(plotresults=FALSE)
}
}
