% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnpp_experiment-reclassify.R
\name{reclassify_droplets}
\alias{reclassify_droplets}
\title{Analysis step: Reclassify droplets}
\usage{
reclassify_droplets(plate)
}
\description{
After classifying droplets into clusters in each well individually, it may
be useful to attempt to reclassify droplets in wells where the gates are
not very clearly defined. This function uses information taken from wells
with a high negative frquency (where the gate is easily defined) to adjust
the gates in the other wells.\cr\cr
\href{https://github.com/daattali/ddpcr#advanced-topic-2-algorithms-used-in-each-step}{See the README} for
more information about the algorithm used.
}
\details{
This function is recommended to be run as part of an analysis pipeline (ie.
within the \code{\link[ddpcr]{analyze}} function) rather than being called
directly.
}
\note{
This is an S3 generic, which means that different ddPCR plate types can
implement this function differently. 
\href{https://github.com/daattali/ddpcr#advanced-topic-3-creating-new-plate-types}{See the README} for
more information on how to implement custom ddPCR plate types.
}
\seealso{
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{reclassify_droplets_single}}\cr
\code{\link[ddpcr]{mark_clusters}}
}
\keyword{internal}

