% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{subset.ddpcr_plate}
\alias{subset.ddpcr_plate}
\title{Subsetting a ddPCR plate}
\usage{
\method{subset}{ddpcr_plate}(x, wells, samples, targets_ch1, targets_ch2,
  ...)
}
\arguments{
\item{x}{The ddPCR plate to subset from.}

\item{wells}{Vector or range notation of wells to select (see Range Notation
section for more information).}

\item{samples}{Vector of sample names to select.}

\item{targets_ch1}{Vector of target names in channel 1 to select.}

\item{targets_ch2}{Vector of target names in channel 2 to select.}

\item{...}{Ignored}
}
\value{
Plate with data only from the specified wells/samples.
}
\description{
Select specific wells or samples from a ddPCR plate.
}
\details{
Keeps only data from the selected wells. If sample names are provided instead
of well IDs, then any well corresponding to any of the sample names will be
kept. Either well IDs or sample names must be provided, but not both.
}
\section{Range notation}{

The most basic way to select wells is to provide a vector of wells such as
\code{c("B03", "C12")}. When selecting wells, a special range notation is
supported to make it easier to select many wells: use a colon (\code{:}) to specify a
range of wells, and use a comma (\code{,}) to add another well or range. When
specifying a range, all wells in the rectangular area between the two wells
are selected. For example, \code{B04:D06} is equivalent to
\code{B04, B05, A05, C04, C05, C06, D04, D05, D06}. You can combine multiple
ranges in one selection; see the Examples section below. Note that this
notation is only supported for the \code{wells} parameter, but not for the
\code{samples} parameter.
}

\examples{
plate <- new_plate(sample_data_dir())
plate \%>\% wells_used
plate \%>\% subset("C01") \%>\% wells_used
plate \%>\% subset(c("C01", "F05")) \%>\% wells_used
plate \%>\% subset("C01, F05") \%>\% wells_used
plate \%>\% subset("C01:F05") \%>\% wells_used
plate \%>\% subset("C01:F05, A01") \%>\% wells_used
plate \%>\% subset("A01:C03") \%>\% wells_used
plate \%>\% subset("A01:C05") \%>\% wells_used
plate \%>\% subset("A01, A05:F05") \%>\% wells_used
plate \%>\% subset("A01, A05:C05, F05") \%>\% wells_used
plate \%>\% subset("A01:A05, C01:C05, F05") \%>\% wells_used
plate \%>\% subset(samples = "Dean") \%>\% wells_used
plate \%>\% subset(samples = c("Dean", "Mike")) \%>\% wells_used
}
