% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate.R
\name{next_step}
\alias{next_step}
\title{Run the next step in an analysis}
\usage{
next_step(plate, n = 1)
}
\arguments{
\item{plate}{A ddPCR plate}

\item{n}{The number of steps to run}
}
\value{
The ddPCR plate after running the next step
}
\description{
Every ddPCR plate has a set of defined steps that are taken in order, that
together constitute "analyzing" the plate.  Calling the \code{next_step} function
will run the next step in the analysis, which may take several minutes. If you
want to run all the remaining steps at once, use \code{\link[ddpcr]{analyze}} instead.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir(), type = plate_types$custom_thresholds)
plate <- next_step(plate)
} 
}
\seealso{
\code{\link[ddpcr]{plot.ddpcr_plate}}\cr
\code{\link[ddpcr]{analyze}}\cr
\code{\link[ddpcr]{steps}}\cr
\code{\link[ddpcr]{plate_data}}\cr
\code{\link[ddpcr]{plate_meta}}
}

