% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mddsPLS.R
\name{MddsPLS_core}
\alias{MddsPLS_core}
\title{The core function of the Multi-Data-Driven sparse PLS function}
\usage{
MddsPLS_core(Xs, Y, lambda = 0, R = 1, mode = "reg",
  verbose = FALSE)
}
\arguments{
\item{Xs}{A data-frame of a matrix or a list of data-frames or matrices of \emph{n} rows each, the number of individuals. Some rows must be missing. The different matrices can have different numbers of columns. The length of Xs is denoted by \emph{K}.}

\item{Y}{A matrix of n rows of a vector of length n detailing the response matrix. No missing values are allowed in that matrix.}

\item{lambda}{A real \eqn{[0,1]} where 1 means just perfect correlations will be used and 0 no regularization is used.}

\item{R}{A strictly positive integer detailing the number of components to build in the model.}

\item{mode}{A character chain. Possibilities are "\emph{reg}", which implies regression problem or anything else which means clustering is considered. Default is "\emph{reg}".}

\item{verbose}{Logical. If TRUE, the function cats specificities about the model. Default is FALSE.}
}
\value{
A list containing the following objects:
\describe{
  \item{u}{A list of length \emph{K}. Each element is a \emph{p_kXR} matrix : the
   weights per block per axis.}
  \item{v}{A \emph{qXR} matrix : the weights for the \emph{Y} part.}
  \item{ts}{A list of length \emph{R}. Each element is a \emph{nXK} matrix : the
   scores per axis per block.}
  \item{(t,s)}{Two \emph{nXR} matrices, scores of the \emph{X} and \emph{Y} parts.}
  \item{(t_frak,s_frak)}{Two \emph{nXR} matrices, final scores of the \emph{X} and \emph{Y} part.
   They correspond to \emph{PLS} scores of \emph{(t,s)} scores and so \emph{t_frak^T s_frak} is diagonal,
   \emph{t_frak}, respectively \emph{s_frak}, carries the same information as \emph{t}, respectively \emph{s}.}
  \item{B}{A list of length \emph{K}. Each element is a \emph{p_kXq} matrix : the
   regression matrix per block.}
  \item{(mu_x_s,sd_x_s)}{Two lists of length \emph{K}. Each element is a \emph{p_k} vector : the
   mean and standard deviation variables per block.}
  \item{(mu_y,sd_y)}{Two vectors of length \emph{q} : the mean and the standard deviation variables for \emph{Y} part.}
  \item{R}{Given as an input.}
  \item{q}{A non negatvie integer : the number of variables of \emph{Y} matrix. }
  \item{Ms}{A list of length \emph{K}. Each element is a \emph{qXp_k} matrix : the
   soft-thresholded empirical variance-covariance matrix \eqn{Y^TX_k/(n-1)}.}
  \item{lambda}{Given as an input.}
}
}
\description{
This function should not be used directly by the user.
}
