% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{data_synthetic}
\alias{data_synthetic}
\title{Synthetic data example}
\format{
A list with 8 elements
}
\usage{
data(data_synthetic)
}
\description{
This list contains one synthetic data with K = 3 latent classes.
The elements are as follows:
}
\details{
\itemize{
\item tree_phylo. A "phylo" tree with K = 3 leaves.
\item class_probability. A K-vector with entries between 0 and 1.
\item item_membership_list. A list of G = 7 elements, where the g-th element contains the
indices of items belonging to major food group g.
\item item_name_list. A list of G = 7 elements, where the g-th element contains the item
labels of items in major food group g, and the name of the g-th element is the major food
group label.
\item Sigma_by_group. A G-vector greater than 0. The group-specific diffusion variances.
\item response_matrix. A binary matrix with N = 100 rows and J = 80 columns. Each row contains
a multivariate binary response vector of a synthetic individual.
\item response_prob. A K by J probability matrix. The k-th row contains the item response
probabilities of class k.
\item tree_with_parameter. A \code{phylobase::phylo4d} object. Basically the tree_phylo embedded
with additional logit(response_prob) at the leaf nodes.
}
}
\keyword{datasets}
