% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_mcmc.R
\name{debinfer_par}
\alias{debinfer_par}
\title{debinfer_par}
\usage{
debinfer_par(name, var.type, fixed, value, joint = NULL, prior = NULL,
  hypers = NULL, prop.var = NULL, samp.type = NULL)
}
\arguments{
\item{name}{character vector; name of the variable}

\item{var.type}{character vector; type of the variable "de" = parameter for the differential equation, "obs" = parameter of the observation model, "init" = initial condition for a state variable in the differential equation}

\item{fixed}{boolean; TRUE = parameter is taken to be fixed, FALSE = parameter is to be estimated by MCMC}

\item{value}{numeric; parameter value. For fixed parameters this is the value used in the analysis for free parameters this is the starting value used when setting up the MCMC chain}

\item{joint}{integer; number of block for joint proposal; NULL means the parameter is not to be jointly proposed}

\item{prior}{character; name of the probability distribution for the prior on the parameter. must conform to standard R naming of d/r function pairs, i.e. beta ( foo = beta), binomial binom, Cauchy cauchy, chi-squared chisq, exponential exp, Fisher F f, gamma gamma, geometric geom, hypergeometric hyper, logistic logis, lognormal lnorm, negative binomial nbinom, normal norm, Poisson pois, Student t t, uniform unif, Weibull weibull, mvnorm}

\item{hypers}{list of numeric vectors, hyperparameters for the prior; mean only for mvnorm. Can include trunc for truncated pdfs from package truncdist.}

\item{prop.var}{numeric; tuning parameters, that is the standard deviation of the proposal distribution for each parameter}

\item{samp.type}{character; type of sampler: "rw" = Normal random walk, "ind" = independence, "rw-unif" = asymmetric uniform distribution}
}
\value{
returns an object of class debinfer_par to be fed to the mcmc setup function
}
\description{
Creates an object containing all the necessary bits for a parameter i.e. initial values, prior distributions,
hyper-parameters, tuning parameters, etc. to set up a debinfer analysis
}

