% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/decisionSupport.R
\name{decisionSupport}
\alias{decisionSupport}
\title{Welfare Decision and Value of Information Analysis wrapper function.}
\usage{
decisionSupport(inputFilePath, outputPath, welfareFunction, numberOfModelRuns,
  randomMethod = "calculate", functionSyntax = "data.frameNames",
  relativeTolerance = 0.05, write_table = TRUE, plsrVipAnalysis = TRUE,
  individualEvpiNames = NULL, sortEvpiAlong = if (individualEvpiNames)
  individualEvpiNames[[1]] else NULL, oldInputStandard = FALSE,
  verbosity = 1)
}
\arguments{
\item{inputFilePath}{Path to input csv file, which gives the input \code{\link{estimate}}.}

\item{outputPath}{Path where the result plots and tables are saved.}

\item{welfareFunction}{The welfare function.}

\item{numberOfModelRuns}{The number of running the welfare model for the underlying Monte Carlo
simulation.}

\item{randomMethod}{\code{character}: The method to be used to sample the distribution
representing the input estimate. For details see option \code{method} in
\code{\link{random.estimate}}.}

\item{functionSyntax}{\code{character}: function syntax used in the welfare function(s). For
details see \code{\link{mcSimulation}}.}

\item{relativeTolerance}{\code{numeric}: the relative tolerance level of deviation of the
generated confidence interval from the specified interval. If this deviation is greater than
\code{relativeTolerance} a warning is given.}

\item{write_table}{\code{logical}: If the full Monte Carlo simulation results and PLSR results should be
written to file.}

\item{plsrVipAnalysis}{\code{logical}: If PLSR-VIP analysis shall be performed.}

\item{individualEvpiNames}{\code{character vector}: names of variables, which for the
 IndividualEVPI shall be obtained via Monte Carlo simulation. If \code{=NULL} (the default), no
 IndividualEVPI is calculated; if \code{="all"}, the IndividualEVPI is calculated for all
 variables. \dfn{Note:} depending on \code{numberOfModelRuns} and the complexity of
 \code{welfare} this might take a long time.}

\item{sortEvpiAlong}{\code{character}: result name along which the summary of the IndividualEVPI
shall be sorted. Only relevant if \code{sortEvpiAlong!=NULL}.}

\item{oldInputStandard}{\code{logical}: If the old input standard should be used
(\code{\link{estimate_read_csv_old}}).}

\item{verbosity}{\code{integer}: if \code{0} the function is silent; the larger the value the
more verbose is output information.}
}
\description{
This function performs a Welfare Decision Analysis via a Monte Carlo simulation from input files
and analyses the value of different information about the input variables. This value of
information analysis can be done via combined PLSR - VIP analysis or via IndividualEVPI
calculation. Results are saved as plots and tables.
}
\details{
This function integrates the most important features of
	\link[=decisionSupport-package]{this package} into a single function. It is wrapped arround the functions
	\code{\link{welfareDecisionAnalysis}}, \code{\link{plsr.mcSimulation}},
	\code{\link[chillR:VIP]{VIP}} and \code{\link{individualEvpiSimulation}}.
  \subsection{Combined PLSR - VIP Analysis}{
  The combined Partial Least Squares Regression (PLSR) and Variables Importance in Projection
  (VIP) analysis is implemented via: \code{\link{plsr.mcSimulation}} and
  \code{\link[chillR:VIP]{VIP}}.
  }
  \subsection{IndividualEVPI Calculation}{
  Implementation: \code{\link{individualEvpiSimulation}}
  }
}
\seealso{
\code{\link{mcSimulation}}, \code{\link{estimate}}, \code{\link{estimate_read_csv}},
	\code{\link{plsr.mcSimulation}}, \code{\link[chillR:VIP]{VIP}},
	\code{\link{welfareDecisionAnalysis}}, \code{\link{individualEvpiSimulation}},
	\code{\link{decisionSupport-package}}
}

